/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.levelhead.core;

import club.sk1er.mods.levelhead.Levelhead;
import club.sk1er.mods.levelhead.config.DisplayConfig;
import club.sk1er.mods.levelhead.config.MasterConfig;
import club.sk1er.mods.levelhead.core.DisplayManager;
import club.sk1er.mods.levelhead.core.ExtensionsKt;
import club.sk1er.mods.levelhead.display.AboveHeadDisplay;
import club.sk1er.mods.levelhead.display.ChatDisplay;
import club.sk1er.mods.levelhead.display.LevelheadDisplay;
import club.sk1er.mods.levelhead.display.LevelheadTag;
import club.sk1er.mods.levelhead.display.TabDisplay;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gg.essential.universal.UMinecraft;
import gg.essential.universal.wrappers.UPlayer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001cJ\u0006\u0010\u001e\u001a\u00020\u001cJ\u0006\u0010\u001f\u001a\u00020\u001cJ\u000e\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\u001cJ\u0006\u0010$\u001a\u00020\u001cJ\u0006\u0010%\u001a\u00020\u001cR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u0017@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006&"}, d2={"Lclub/sk1er/mods/levelhead/core/DisplayManager;", "", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "aboveHead", "", "Lclub/sk1er/mods/levelhead/display/AboveHeadDisplay;", "getAboveHead", "()Ljava/util/List;", "<set-?>", "Lclub/sk1er/mods/levelhead/display/ChatDisplay;", "chat", "getChat", "()Lclub/sk1er/mods/levelhead/display/ChatDisplay;", "config", "Lclub/sk1er/mods/levelhead/config/MasterConfig;", "getConfig", "()Lclub/sk1er/mods/levelhead/config/MasterConfig;", "setConfig", "(Lclub/sk1er/mods/levelhead/config/MasterConfig;)V", "getFile", "()Ljava/io/File;", "Lclub/sk1er/mods/levelhead/display/TabDisplay;", "tab", "getTab", "()Lclub/sk1er/mods/levelhead/display/TabDisplay;", "adjustIndices", "", "checkCacheSizes", "clearCache", "joinWorld", "playerJoin", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "readConfig", "saveConfig", "update", "levelhead"})
public final class DisplayManager {
    @NotNull
    private final File file;
    @NotNull
    private MasterConfig config;
    @NotNull
    private final List<AboveHeadDisplay> aboveHead;
    private ChatDisplay chat;
    private TabDisplay tab;

    public DisplayManager(@NotNull File file) {
        this.file = file;
        this.config = new MasterConfig();
        this.aboveHead = new ArrayList();
        this.readConfig();
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final MasterConfig getConfig() {
        return this.config;
    }

    public final void setConfig(@NotNull MasterConfig masterConfig) {
        this.config = masterConfig;
    }

    @NotNull
    public final List<AboveHeadDisplay> getAboveHead() {
        return this.aboveHead;
    }

    @NotNull
    public final ChatDisplay getChat() {
        ChatDisplay chatDisplay = this.chat;
        if (chatDisplay != null) {
            return chatDisplay;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"chat");
        return null;
    }

    @NotNull
    public final TabDisplay getTab() {
        TabDisplay tabDisplay = this.tab;
        if (tabDisplay != null) {
            return tabDisplay;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"tab");
        return null;
    }

    public final void readConfig() {
        try {
            Object it;
            DisplayManager displayManager;
            JsonElement jsonElement;
            Object $this$readConfig_u24lambda_u2d0;
            boolean shouldSaveCopyNow = false;
            if (!this.file.exists()) {
                this.file.createNewFile();
                shouldSaveCopyNow = true;
            }
            Object object = Levelhead.INSTANCE.getJsonParser().parse(FileUtils.readFileToString((File)this.file, (Charset)Charsets.UTF_8));
            try {
                $this$readConfig_u24lambda_u2d0 = object;
                boolean bl = false;
                $this$readConfig_u24lambda_u2d0 = Result.constructor-impl((Object)$this$readConfig_u24lambda_u2d0.getAsJsonObject());
            }
            catch (Throwable bl) {
                $this$readConfig_u24lambda_u2d0 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$readConfig_u24lambda_u2d0;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) {
                jsonElement = object;
            } else {
                Throwable it2 = throwable;
                boolean bl = false;
                jsonElement = new JsonObject();
            }
            JsonObject source = (JsonObject)jsonElement;
            if (source.has("master")) {
                object = Levelhead.INSTANCE.getGson().fromJson((JsonElement)source.get("master").getAsJsonObject(), MasterConfig.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.fromJson(source[\"ma\u2026MasterConfig::class.java)");
                this.config = (MasterConfig)object;
            }
            if (source.has("head")) {
                for (Object head : source.get("head").getAsJsonArray()) {
                    Object it2 = Levelhead.INSTANCE.getGson().fromJson((JsonElement)head.getAsJsonObject(), DisplayConfig.class);
                    Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"gson.fromJson(head.asJso\u2026isplayConfig::class.java)");
                    this.aboveHead.add(new AboveHeadDisplay((DisplayConfig)it2));
                }
            }
            if (this.aboveHead.isEmpty()) {
                this.aboveHead.add(new AboveHeadDisplay(new DisplayConfig()));
            }
            if (source.has("chat")) {
                object = Levelhead.INSTANCE.getGson().fromJson((JsonElement)source.get("chat").getAsJsonObject(), DisplayConfig.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.fromJson(source[\"ch\u2026isplayConfig::class.java)");
                this.chat = new ChatDisplay((DisplayConfig)object);
            } else {
                Object head;
                object = new DisplayConfig();
                head = object;
                displayManager = this;
                boolean bl = false;
                ((DisplayConfig)it).setType("GUILD_NAME");
                Object object2 = object;
                displayManager.chat = new ChatDisplay((DisplayConfig)object2);
            }
            if (source.has("tab")) {
                object = Levelhead.INSTANCE.getGson().fromJson((JsonElement)source.get("tab").getAsJsonObject(), DisplayConfig.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.fromJson(source[\"ta\u2026isplayConfig::class.java)");
                this.tab = new TabDisplay((DisplayConfig)object);
            } else {
                it = object = new DisplayConfig();
                displayManager = this;
                boolean bl = false;
                ((DisplayConfig)it).setType("QUESTS");
                Object object3 = object;
                displayManager.tab = new TabDisplay((DisplayConfig)object3);
            }
            this.adjustIndices();
            if (shouldSaveCopyNow) {
                this.saveConfig();
            }
        }
        catch (IOException e) {
            Levelhead.INSTANCE.getLogger().error("Failed to initialize display manager.", (Throwable)e);
        }
    }

    public final void saveConfig() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("master", Levelhead.INSTANCE.getGson().toJsonTree((Object)this.config));
        jsonObject.add("tab", Levelhead.INSTANCE.getGson().toJsonTree((Object)this.getTab().getConfig()));
        jsonObject.add("chat", Levelhead.INSTANCE.getGson().toJsonTree((Object)this.getChat().getConfig()));
        JsonArray head = new JsonArray();
        Iterable $this$forEach$iv = this.aboveHead;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AboveHeadDisplay display = (AboveHeadDisplay)element$iv;
            boolean bl = false;
            head.add(Levelhead.INSTANCE.getGson().toJsonTree((Object)display.getConfig()));
        }
        jsonObject.add("head", (JsonElement)head);
        try {
            FileUtils.writeStringToFile((File)this.file, (String)jsonObject.toString(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            Levelhead.INSTANCE.getLogger().error("Failed to write to config.", (Throwable)e);
        }
    }

    public final void adjustIndices() {
        int n = 0;
        int n2 = this.aboveHead.size();
        while (n < n2) {
            int i;
            this.aboveHead.get(i).setBottomValue((i = n++) == 0);
            this.aboveHead.get(i).setIndex(i);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void joinWorld() {
        List list;
        void $this$filterIndexedTo$iv$iv;
        void $this$filterIndexed$iv;
        List list2;
        List $this$joinWorld_u24lambda_u2d6 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (Levelhead.LevelheadPurchaseStates.INSTANCE.getChat()) {
            $this$joinWorld_u24lambda_u2d6.add(this.getChat());
        }
        if (Levelhead.LevelheadPurchaseStates.INSTANCE.getTab()) {
            $this$joinWorld_u24lambda_u2d6.add(this.getTab());
        }
        Iterable iterable = this.getAboveHead();
        List list3 = $this$joinWorld_u24lambda_u2d6;
        boolean $i$f$filterIndexed2 = false;
        void var8_10 = $this$filterIndexed$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed2 = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl2 = false;
            AboveHeadDisplay aboveHeadDisplay = (AboveHeadDisplay)element$iv$iv;
            int i = index$iv$iv;
            boolean bl3 = false;
            if (!(i <= Levelhead.LevelheadPurchaseStates.INSTANCE.getAboveHead())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list3.addAll((List)destination$iv$iv);
        List displays = CollectionsKt.build((List)list2);
        list2 = UMinecraft.getWorld();
        if (list2 != null && (list = ((WorldClient)list2).field_73010_i) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable $i$f$filterIndexed2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                EntityPlayer $i$f$forEachIndexed2 = (EntityPlayer)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                Iterable $this$map$iv2 = displays;
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    void playerInfo;
                    LevelheadDisplay i = (LevelheadDisplay)item$iv$iv2;
                    Collection collection2 = destination$iv$iv3;
                    boolean bl5 = false;
                    UUID uUID = playerInfo.func_110124_au();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"playerInfo.uniqueID");
                    collection2.add(new Levelhead.LevelheadRequest(ExtensionsKt.getTrimmed(uUID), (LevelheadDisplay)it, it instanceof AboveHeadDisplay ? ((AboveHeadDisplay)it).getBottomValue() : false, null, 8, null));
                }
                collection.add((List)destination$iv$iv3);
            }
            List list4 = (List)destination$iv$iv2;
            List list5 = CollectionsKt.flatten((Iterable)list4);
            if (list5 != null) {
                CollectionsKt.chunked((Iterable)list5, (int)20, (Function1)joinWorld.2.INSTANCE);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void playerJoin(@NotNull EntityPlayer player) {
        void $this$mapTo$iv$iv;
        LevelheadDisplay it;
        Iterable $this$filterTo$iv$iv;
        void $this$filterIndexedTo$iv$iv;
        void $this$filterIndexed$iv;
        if (ExtensionsKt.isNPC(player)) {
            return;
        }
        Collection collection = CollectionsKt.createListBuilder();
        List $this$playerJoin_u24lambda_u2d10 = collection;
        boolean $i$a$-buildList-DisplayManager$playerJoin$displays$22 = false;
        if (Levelhead.LevelheadPurchaseStates.INSTANCE.getChat()) {
            $this$playerJoin_u24lambda_u2d10.add(this.getChat());
        }
        if (Levelhead.LevelheadPurchaseStates.INSTANCE.getTab()) {
            $this$playerJoin_u24lambda_u2d10.add(this.getTab());
        }
        Iterable iterable = this.getAboveHead();
        List list = $this$playerJoin_u24lambda_u2d10;
        boolean $i$f$filterIndexed = false;
        void var9_14 = $this$filterIndexed$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            AboveHeadDisplay aboveHeadDisplay = (AboveHeadDisplay)element$iv$iv;
            int i = index$iv$iv;
            boolean bl2 = false;
            if (!(i <= Levelhead.LevelheadPurchaseStates.INSTANCE.getAboveHead())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list.addAll((List)destination$iv$iv);
        List displays = CollectionsKt.build((List)collection);
        Iterable $this$filter$iv = displays;
        boolean $i$f$filter = false;
        Iterable $i$a$-buildList-DisplayManager$playerJoin$displays$22 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (LevelheadDisplay)element$iv$iv;
            boolean bl = false;
            if (!(!it.getCache().containsKey(player.func_110124_au()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (LevelheadDisplay)item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl = false;
            UUID uUID = player.func_110124_au();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueID");
            collection2.add(new Levelhead.LevelheadRequest(ExtensionsKt.getTrimmed(uUID), it, it instanceof AboveHeadDisplay ? ((AboveHeadDisplay)it).getBottomValue() : false, null, 8, null));
        }
        collection = (List)destination$iv$iv2;
        if (collection.isEmpty()) {
            boolean bl = false;
            return;
        }
        List $this$playerJoin_u24lambda_u2d14 = (List)collection;
        boolean bl = false;
        Levelhead.INSTANCE.fetch($this$playerJoin_u24lambda_u2d14);
    }

    /*
     * WARNING - void declaration
     */
    public final void update() {
        LevelheadTag.LevelheadComponent it;
        LevelheadTag tag2;
        Map.Entry element$iv;
        Iterable $this$forEachIndexed$iv = this.aboveHead;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void head;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AboveHeadDisplay aboveHeadDisplay = (AboveHeadDisplay)item$iv;
            int i = n;
            boolean bl = false;
            if (i == 0 && Levelhead.LevelheadPurchaseStates.INSTANCE.getCustomLevelhead() || i > Levelhead.LevelheadPurchaseStates.INSTANCE.getAboveHead()) continue;
            Map $this$forEach$iv = head.getCache();
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv2;
                Map.Entry $dstr$_u24__u24$tag = element$iv2 = iterator.next();
                boolean bl2 = false;
                LevelheadTag tag3 = (LevelheadTag)$dstr$_u24__u24$tag.getValue();
                if (Intrinsics.areEqual((Object)tag3.getOwner(), (Object)UPlayer.getUUID()) && i == 0 && Levelhead.LevelheadPurchaseStates.INSTANCE.getCustomLevelhead()) continue;
                LevelheadTag.LevelheadComponent $this$update_u24lambda_u2d18_u24lambda_u2d17_u24lambda_u2d15 = tag3.getHeader();
                boolean bl3 = false;
                $this$update_u24lambda_u2d18_u24lambda_u2d17_u24lambda_u2d15.setChroma(head.getConfig().getHeaderChroma());
                $this$update_u24lambda_u2d18_u24lambda_u2d17_u24lambda_u2d15.setColor(head.getConfig().getHeaderColor());
                $this$update_u24lambda_u2d18_u24lambda_u2d17_u24lambda_u2d15.setValue(Intrinsics.stringPlus((String)head.getConfig().getHeaderString(), (Object)": "));
                LevelheadTag.LevelheadComponent $this$update_u24lambda_u2d18_u24lambda_u2d17_u24lambda_u2d16 = tag3.getFooter();
                boolean bl4 = false;
                $this$update_u24lambda_u2d18_u24lambda_u2d17_u24lambda_u2d16.setChroma(head.getConfig().getFooterChroma());
                $this$update_u24lambda_u2d18_u24lambda_u2d17_u24lambda_u2d16.setColor(head.getConfig().getFooterColor());
            }
        }
        ChatDisplay $this$update_u24lambda_u2d22 = this.getChat();
        boolean bl = false;
        Map $this$forEach$iv = $this$update_u24lambda_u2d22.getCache();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry $dstr$_u24__u24$tag = element$iv = iterator.next();
            boolean bl5 = false;
            tag2 = (LevelheadTag)$dstr$_u24__u24$tag.getValue();
            it = tag2.getHeader();
            boolean bl6 = false;
            it.setChroma($this$update_u24lambda_u2d22.getConfig().getHeaderChroma());
            it.setColor($this$update_u24lambda_u2d22.getConfig().getHeaderColor());
            it = tag2.getFooter();
            boolean bl7 = false;
            it.setChroma($this$update_u24lambda_u2d22.getConfig().getFooterChroma());
            it.setColor($this$update_u24lambda_u2d22.getConfig().getFooterColor());
        }
        TabDisplay $this$update_u24lambda_u2d26 = this.getTab();
        boolean bl8 = false;
        $this$forEach$iv = $this$update_u24lambda_u2d26.getCache();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry $dstr$_u24__u24$tag = element$iv = iterator.next();
            boolean bl9 = false;
            tag2 = (LevelheadTag)$dstr$_u24__u24$tag.getValue();
            it = tag2.getHeader();
            boolean bl10 = false;
            it.setChroma($this$update_u24lambda_u2d26.getConfig().getHeaderChroma());
            it.setColor($this$update_u24lambda_u2d26.getConfig().getHeaderColor());
            it = tag2.getFooter();
            boolean bl11 = false;
            it.setChroma($this$update_u24lambda_u2d26.getConfig().getFooterChroma());
            it.setColor($this$update_u24lambda_u2d26.getConfig().getFooterColor());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void checkCacheSizes() {
        Iterable $this$forEachIndexed$iv = this.aboveHead;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void head;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AboveHeadDisplay aboveHeadDisplay = (AboveHeadDisplay)item$iv;
            int i = n;
            boolean bl = false;
            if (i > Levelhead.LevelheadPurchaseStates.INSTANCE.getAboveHead()) continue;
            head.checkCacheSize();
        }
        this.getChat().checkCacheSize();
        this.getTab().checkCacheSize();
    }

    /*
     * WARNING - void declaration
     */
    public final void clearCache() {
        Iterable $this$forEachIndexed$iv = this.aboveHead;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void head;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AboveHeadDisplay aboveHeadDisplay = (AboveHeadDisplay)item$iv;
            int i = n;
            boolean bl = false;
            if (i > Levelhead.LevelheadPurchaseStates.INSTANCE.getAboveHead()) continue;
            head.getCache().clear();
        }
        this.getChat().getCache().clear();
        this.getTab().getCache().clear();
        this.joinWorld();
    }
}

